#!/bin/sh

echo "BIXOLON CO Ltd"
echo "BIXOLON Label CUPS DRIVER Installer"
echo "---------------------------------------"
echo ""
echo ""

USER_ID=$(id -u)
ROOT_UID=0

if [ "$USER_ID" -ne "$ROOT_UID" ]
then
    echo "This script requires root user access..."
    echo "Re-run as root user..."
    exit 1
fi

LINUX_CHECK_GENTOO="$(cat /etc/*-release | grep -ic gentoo)"
LINUX_CHECK_RHEL7="$(cat /etc/*-release | grep -ic "Red Hat Enterprise Linux 7")"
NO_GENTOO=0
NO_RHEL7=0

LINUX_CHECK_ARCH_x64="$(uname -a | grep -ic x86_64)"
LINUX_CHECK_ARCH_x86="$(uname -a | grep -ic i[4,5,6]86)"
LINUX_CHECK_ARCH_AARCH64="$(uname -a | grep -ic aarch64)"
LINUX_CHECK_ARCH_ARMV7L="$(uname -a | grep -ic armv7l)"

if [ ${LINUX_CHECK_GENTOO} = ${NO_GENTOO} ]
then
LIBPATH="lib"
else
LIBPATH="libexec"
fi

echo "Checking previous driver..."
echo ""

INSTALLED_FILE=/usr/${LIBPATH}/cups/filter/rastertoBxlLabel

if [ ! -f "$INSTALLED_FILE" ]
then
	echo ""
	echo "Previous driver does not exist."
	echo ""
else
	echo "Previous driver exist."
	echo ""
	echo "Removing previous filter..."
	sudo rm -f /usr/bin/rastertoBxlLabel*
	sudo rm -f /usr/${LIBPATH}/cups/filter/rastertoBxlLabel*
	echo ""
	echo "Removing previous model ppd files..."
	sudo rm -f /usr/share/cups/model/Bixolon/SLP*
	sudo rm -f /usr/share/cups/model/Bixolon/SPPL*
	sudo rm -f /usr/share/cups/model/Bixolon/SRP7*
	sudo rm -f /usr/share/cups/model/Bixolon/SRPE7*
	sudo rm -f /usr/share/cups/model/Bixolon/SRPS3000_LABEL*
	sudo rm -f /usr/share/cups/model/Bixolon/XD*
	sudo rm -f /usr/share/cups/model/Bixolon/XL*
	sudo rm -f /usr/share/cups/model/Bixolon/XM*
	sudo rm -f /usr/share/cups/model/Bixolon/XT*
	
	sudo rm -f /usr/share/cups/ppd/Bixolon/SLP*
	sudo rm -f /usr/share/cups/ppd/Bixolon/SPPL*
	sudo rm -f /usr/share/cups/ppd/Bixolon/SRP7*
	sudo rm -f /usr/share/cups/ppd/Bixolon/SRPE7*
	sudo rm -f /usr/share/cups/ppd/Bixolon/SRPS3000_LABEL*
	sudo rm -f /usr/share/cups/ppd/Bixolon/XD*
	sudo rm -f /usr/share/cups/ppd/Bixolon/XL*
	sudo rm -f /usr/share/cups/ppd/Bixolon/XM*
	sudo rm -f /usr/share/cups/ppd/Bixolon/XT*
	echo ""
	echo "Removing previous log files..."
	sudo rm -f /tmp/bixolonlogs
	sudo rm -f /tmp/bixolonlistp
	echo ""
fi

if [ ${LINUX_CHECK_ARCH_x64} -eq 1 ]
then
	FILTER=rastertoBxlLabel_v1.2.7_x64
elif [ ${LINUX_CHECK_ARCH_x86} -eq 1 ]
then
	FILTER=rastertoBxlLabel_v1.2.7_x86
elif [ ${LINUX_CHECK_ARCH_AARCH64} -eq 1 ]
then
	FILTER=rastertoBxlLabel_v1.2.7_RaspberryPi_x64
elif [ ${LINUX_CHECK_ARCH_ARMV7L} -eq 1 ]
then
	FILTER=rastertoBxlLabel_v1.2.7_RaspberryPi_x86
else
	echo "The installation cancelled with unrecognized CPU architecture error."
	echo ""
	exit
fi

echo "Copying rastertoBxlLabel($FILTER) filter..."
 sudo chmod +x ./filters/${FILTER}
 sudo cp ./filters/${FILTER} /usr/bin/
 sudo chmod 0755 /usr/bin/${FILTER}
echo ""

echo "Creating Symbolic Link...."
  sudo ln -s /usr/bin/${FILTER} /usr/${LIBPATH}/cups/filter/rastertoBxlLabel
  sudo chmod 0755 /usr/${LIBPATH}/cups/filter/rastertoBxlLabel
echo ""

echo "Copying model ppd files... "
   sudo chmod +x ./Bixolon/*


if [ -x /etc/init.d/cupsys ]
then
	if [ -r /etc/debian_version ]
	then
		if [ -r /etc/lsb-release ]
		then
             sudo cp -r ./Bixolon /usr/share/cups/model/
			 sudo chmod 0755 /usr/share/cups/model/Bixolon/*
		else
             sudo cp ./Bixolon /usr/share/ppd/ 
			 sudo chmod 0755 /usr/share/ppd/Bixolon/*
		fi
	else
         sudo cp -r ./Bixolon /usr/share/cups/model/
         sudo chmod 0755 /usr/share/cups/model/Bixolon/*
	fi
else
	if [ -r /etc/debian_version ]
	then
         sudo cp -r ./Bixolon /usr/share/cups/model/
         sudo chmod 0755 /usr/share/cups/model/Bixolon/*
	else
         sudo cp -r ./Bixolon /usr/share/cups/model/
         sudo chmod 0755 /usr/share/cups/model/Bixolon/*
	fi
fi 
echo ""

echo "Restarting CUPS"
    if [ -x /etc/software/init.d/cups ]
    then
        sudo /etc/software/init.d/cups stop
        sudo /etc/software/init.d/cups start
    elif [ -x /etc/rc.d/init.d/cups ]
    then
        sudo /etc/rc.d/init.d/cups stop
        sudo /etc/rc.d/init.d/cups start
    elif [ -x /etc/init.d/cups ]
    then
        sudo /etc/init.d/cups stop
        sudo /etc/init.d/cups start
    elif [ -x /sbin/init.d/cups ]
    then
        sudo /sbin/init.d/cups stop
        sudo /sbin/init.d/cups start
    elif [ -x /etc/software/init.d/cupsys ]
    then
        sudo /etc/software/init.d/cupsys stop
        sudo /etc/software/init.d/cupsys start
    elif [ -x /etc/rc.d/init.d/cupsys ]
    then
        sudo /etc/rc.d/init.d/cupsys stop
        sudo /etc/rc.d/init.d/cupsys start
    elif [ -x /etc/init.d/cupsys ]
    then
        sudo /etc/init.d/cupsys stop
        sudo /etc/init.d/cupsys start
    elif [ -x /sbin/init.d/cupsys ]
    then
        sudo /sbin/init.d/cupsys stop
        sudo /sbin/init.d/cupsys start
    elif [ ${LINUX_CHECK_RHEL7} -gt ${NO_RHEL7} ]
    then
	sudo systemctl restart cups.service
    else
        echo "Could not restart CUPS"
    fi

	if [ ${LINUX_CHECK_GENTOO} = ${NO_GENTOO} ]
	then
		if [ ${LINUX_CHECK_RHEL7} -gt ${NO_RHEL7} ]
		then
			sudo systemctl restart cups.service
		else
			sudo service cups stop
			sudo service cups start
		fi
	else
		sudo service cupsd stop
		sudo service cupsd start
	fi

    echo ""


echo "Install Complete"
echo "Add printer queue using OS tool, http://localhost:631, or http://127.0.0.1:631"
echo ""

